<?php
function install_aos() {

    require_once('modules/Administration/Administration.php');

	global $sugar_config;

	$sugar_config['aos']['version'] = '5.3.3';
    if(!isset($sugar_config['aos']['contracts']['renewalReminderPeriod'])) $sugar_config['aos']['contracts']['renewalReminderPeriod'] = '14';
    if(!isset($sugar_config['aos']['lineItems']['totalTax'])) $sugar_config['aos']['lineItems']['totalTax'] = false;
    if(!isset($sugar_config['aos']['lineItems']['enableGroups'])) $sugar_config['aos']['lineItems']['enableGroups'] = true;
    if(!isset($sugar_config['aos']['invoices']['initialNumber'])) $sugar_config['aos']['invoices']['initialNumber'] = '1';
    if(!isset($sugar_config['aos']['quotes']['initialNumber'])) $sugar_config['aos']['quotes']['initialNumber'] = '1';
	
	ksort($sugar_config);
	write_array_to_file('sugar_config', $sugar_config, 'config.php');

    setup_custom();
		
}

function setup_custom(){
    require_once('modules/Administration/Administration.php');
    require_once('include/utils/array_utils.php');
    require_once('include/utils/file_utils.php');
    require_once('include/utils/sugar_file_utils.php');


    $modules_array = array('Accounts','Contacts','Leads');

    foreach($modules_array as $module){

        if(isset($viewdefs)) unset($viewdefs);

        $file = "custom/modules/$module/metadata/detailviewdefs.php";
        if(file_exists($file)){
            include($file);
        }else{
            include("modules/$module/metadata/detailviewdefs.php");
        }
        if(isset($viewdefs["$module"]['DetailView']['templateMeta']['form']['buttons']['AOS_GENLET'])) unset($viewdefs["$module"]['DetailView']['templateMeta']['form']['buttons']['AOS_GENLET']);

        $viewdefs["$module"]['DetailView']['templateMeta']['form']['buttons']['AOS_GENLET'] = array('customCode'=>'<input type="button" class="button" onClick="showPopup();" value="{$APP.LBL_GENERATE_LETTER}">');

        ksort($viewdefs);
        write_array_to_file('viewdefs', $viewdefs, $file);
    }


    /** add following:
    $entry_point_registry['formLetter'] = array('file' => 'modules/AOS_PDF_Templates/formLetterPdf.php', 'auth' => true);
    $entry_point_registry['generatePdf'] = array('file' => 'modules/AOS_PDF_Templates/generatePdf.php', 'auth' => true);
     */

    $add_entry_point = false;
    $new_contents = "";
    $entry_point_registry = null;
    if(file_exists("custom/include/MVC/Controller/entry_point_registry.php")){

        // This will load an array of the hooks to process
        include("custom/include/MVC/Controller/entry_point_registry.php");


        if(!isset($entry_point_registry['formLetter'])) {
            $add_entry_point = true;
            $entry_point_registry['formLetter'] = array('file' => 'modules/AOS_PDF_Templates/formLetterPdf.php', 'auth' => true);
        }
        if(!isset($entry_point_registry['generatePdf'])) {
            $add_entry_point = true;
            $entry_point_registry['generatePdf'] = array('file' => 'modules/AOS_PDF_Templates/generatePdf.php', 'auth' => true);
        }
    } else {
        $add_entry_point = true;
        $entry_point_registry['formLetter'] = array('file' => 'modules/AOS_PDF_Templates/formLetterPdf.php', 'auth' => true);
        $entry_point_registry['generatePdf'] = array('file' => 'modules/AOS_PDF_Templates/generatePdf.php', 'auth' => true);
    }
    if($add_entry_point == true){

        foreach($entry_point_registry as $entryPoint => $epArray){
            $new_contents .= "\$entry_point_registry['".$entryPoint."'] = array('file' => '".$epArray['file']."' , 'auth' => '".$epArray['auth']."'); \n";
        }

        $new_contents = "<?php\n$new_contents\n?>";
        $file = 'custom/include/MVC/Controller/entry_point_registry.php';
        $paths = explode('/',$file);
        $dir = '';
        for($i = 0; $i < sizeof($paths) - 1; $i++)
        {
            if($i > 0) $dir .= '/';
            $dir .= $paths[$i];
            if(!file_exists($dir))
            {
                sugar_mkdir($dir, 0755);
            }
        }
        $fp = sugar_fopen($file, 'wb');
        fwrite($fp,$new_contents);
        fclose($fp);
    }
}


function upgrade_aos(){
    global $sugar_config, $db;
    if(!isset($sugar_config['aos']['version']) || $sugar_config['aos']['version'] < 5.2){
        $db->query("UPDATE  aos_pdf_templates SET type = 'AOS_Quotes' WHERE type = 'Quotes'");
        $db->query("UPDATE  aos_pdf_templates SET type = 'AOS_Invoices' WHERE type = 'Invoices'");

        require_once('include/utils/file_utils.php');

        $old_files = array(
            'custom/Extension/modules/Accounts/Ext/Layoutdefs/Account.php',
            'custom/Extension/modules/Accounts/Ext/Vardefs/Account.php',
            'custom/Extension/modules/Contacts/Ext/Layoutdefs/Contact.php',
            'custom/Extension/modules/Contacts/Ext/Vardefs/Contact.php',
            'custom/Extension/modules/Opportunities/Ext/Layoutdefs/Opportunity.php',
            'custom/Extension/modules/Opportunities/Ext/Vardefs/Opportunity.php',
            'custom/Extension/modules/Project/Ext/Layoutdefs/Project.php',
            'custom/Extension/modules/Project/Ext/Vardefs/Project.php',
            'modules/AOS_Quotes/js/Quote.js',
        );

        foreach($old_files as $old_file){
            if( file_exists($old_file)){
                create_custom_directory('bak_aos/'.$old_file);
                sugar_rename($old_file, 'custom/bak_aos/'.$old_file);
            }
        }

    }
}
?>
