<?php
if(!defined('sugarEntry'))define('sugarEntry', true);
/*********************************************************************************
 * The contents of this file are subject to the SugarCRM Public License Version
 * 1.1.3 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.sugarcrm.com/SPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by SugarCRM" logo and
 *    (ii) the SugarCRM copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: SugarCRM Open Source
 * The Initial Developer of the Original Code is SugarCRM, Inc.
 * Portions created by SugarCRM are Copyright (C) 2004-2006 SugarCRM, Inc.;
 * All Rights Reserved.
 * Contributor(s): ______________________________________.
 ********************************************************************************/
ini_set('display_errors',1);
error_reporting(E_ALL ^ E_STRICT);

require_once('include/entryPoint.php');
require_once('modules/Leads/Lead.php');


if(isset($_POST['customer_data'])){

	$customer_data = str_replace("&quot;","\"",$_POST['customer_data']);
	$customer_data = json_decode($customer_data,true);
	
	if(isset($customer_data)){
		if(is_array($customer_data)){
			$objLead = new Lead();
			$objLead->first_name = $customer_data['firstname'];
			$objLead->last_name = $customer_data['lastname'];
			$objLead->email1 = $customer_data['email'];
			$objLead->lead_source = "Web Site";

			$objLead->phone_work = (isset($customer_data['billingDetails']['billing_telephone'])) ? $customer_data['billingDetails']['billing_telephone'] : '';
			$objLead->phone_fax = (isset($customer_data['billingDetails']['billing_fax'])) ? $customer_data['billingDetails']['billing_fax'] : '';

			$billing_add_street = '';
			if(isset($customer_data['billingDetails']['billing_street'])){
				$billing_add_street .= $customer_data['billingDetails']['billing_street'];
				if(isset($customer_data['billingDetails']['billing_district'])){
					$billing_add_street .= " ".$customer_data['billingDetails']['billing_district'];
				}
			}

			$objLead->primary_address_street = $billing_add_street;
			$objLead->primary_address_city = (isset($customer_data['billingDetails']['billing_city'])) ? $customer_data['billingDetails']['billing_city'] : '';
			$objLead->primary_address_state = (isset($customer_data['billingDetails']['billing_state'])) ? $customer_data['billingDetails']['billing_state'] : '';
			$objLead->primary_address_postalcode = (isset($customer_data['billingDetails']['billing_zip'])) ? $customer_data['billingDetails']['billing_zip'] : '';
			$objLead->primary_address_country =  (isset($customer_data['billingDetails']['billing_country'])) ? $customer_data['billingDetails']['billing_country'] : '';


			$objLead->description = "WebStore ID: ".$customer_data['entity_id'];
			$objLead->magento_id_c = $customer_data['entity_id'];
			$objLead->save();

			echo"lead saved";
		}
	}

} //end action customerregistry

if(isset($_POST['order_data'])){

	require_once('modules/Accounts/Account.php');
	require_once('modules/Contacts/Contact.php');

function newLead($order_data){
	$objLead = new Lead();
	$name = explode(" ", $order_data['shippingDetails']['shipping_name']);
	$objLead->first_name = $name['0'];
	$objLead->last_name = $name['1'];
	$objLead->email1 = $order_data['cust_email'];
	$objLead->lead_source = "Web Site";

	$objLead->description = "WebStore ID: ".$order_data['cust_id'];
	$objLead->magento_id_c = $order_data['cust_id'];
	$objLead->save();

	$lead_arr = array();
	$lead_arr['lead_id'] = $objLead->id;
	$lead_arr['fname'] = $objLead->first_name;
	$lead_arr['lname'] = $objLead->last_name;

	return $lead_arr;
}

function updateLead($id_c,$o_data){
	$objLead = new Lead();
	$objLead->retrieve($id_c);

	$name = explode(" ", $o_data['shippingDetails']['shipping_name']);
	$objLead->first_name = $name['0'];
	$objLead->last_name = $name['1'];
	$objLead->email1 = $o_data['cust_email'];

	$objLead->phone_work = $o_data['shippingDetails']['shipping_telephone'];
	$objLead->phone_mobile = $o_data['billingDetails']['billing_telephone'];

	$objLead->primary_address_street = $o_data['billingDetails']['billing_street']." ".$o_data['billingDetails']['billing_district'];
	$objLead->primary_address_city = $o_data['billingDetails']['billing_city'];
	$objLead->primary_address_state = $o_data['billingDetails']['billing_state'];
	$objLead->primary_address_postalcode = $o_data['billingDetails']['billing_zip'];
	$objLead->primary_address_country =  $o_data['billingDetails']['billing_country'];

	$objLead->alt_address_street = $o_data['shippingDetails']['shipping_street']." ".$o_data['shippingDetails']['shipping_district'];
	$objLead->alt_address_city = $o_data['shippingDetails']['shipping_city'];
	$objLead->alt_address_state = $o_data['shippingDetails']['shipping_state'];
	$objLead->alt_address_postalcode = $o_data['shippingDetails']['shipping_zip'];
	$objLead->alt_address_country = $o_data['shippingDetails']['shipping_country'];

	$objLead->save();
	
	$lead_arr = array();
	$lead_arr['lead_id'] = $objLead->id;
	$lead_arr['fname'] = $objLead->first_name;
	$lead_arr['lname'] = $objLead->last_name;

	return $lead_arr;
}

function newAccount($l_data,$o_data){
	$objAccount = new Account();
	$objAccount->name = $l_data['fname']." ".$l_data['lname'];
	$objAccount->email1 = $o_data['cust_email'];
	$objAccount->phone_office = $o_data['shippingDetails']['shipping_telephone'];
	$objAccount->phone_fax = $o_data['billingDetails']['billing_telephone'];

	$objAccount->billing_address_street = $o_data['billingDetails']['billing_street']." ".$o_data['billingDetails']['billing_district'];
	$objAccount->billing_address_city = $o_data['billingDetails']['billing_city'];
	$objAccount->billing_address_state = $o_data['billingDetails']['billing_state'];
	$objAccount->billing_address_postalcode = $o_data['billingDetails']['billing_zip'];
	$objAccount->billing_address_country =  $o_data['billingDetails']['billing_country'];

	$objAccount->shipping_address_street = $o_data['shippingDetails']['shipping_street']." ".$o_data['shippingDetails']['shipping_district'];
	$objAccount->shipping_address_city = $o_data['shippingDetails']['shipping_city'];
	$objAccount->shipping_address_state = $o_data['shippingDetails']['shipping_state'];
	$objAccount->shipping_address_postalcode = $o_data['shippingDetails']['shipping_zip'];
	$objAccount->shipping_address_country = $o_data['shippingDetails']['shipping_country'];

	$objAccount->save();

	$account_arr = array();
	$account_arr['account_id'] = $objAccount->id;

	return $account_arr;
}

function updateAccount($a_id, $l_data,$o_data){
	$objAccount = new Account();

	$objAccount->retrieve($a_id);

	$objAccount->name = $l_data['fname']." ".$l_data['lname'];
	$objAccount->email1 = $o_data['cust_email'];
	$objAccount->phone_office = $o_data['shippingDetails']['shipping_telephone'];
	$objAccount->phone_fax = $o_data['billingDetails']['billing_telephone'];

	$objAccount->billing_address_street = $o_data['billingDetails']['billing_street']." ".$o_data['billingDetails']['billing_district'];
	$objAccount->billing_address_city = $o_data['billingDetails']['billing_city'];
	$objAccount->billing_address_state = $o_data['billingDetails']['billing_state'];
	$objAccount->billing_address_postalcode = $o_data['billingDetails']['billing_zip'];
	$objAccount->billing_address_country =  $o_data['billingDetails']['billing_country'];

	$objAccount->shipping_address_street = $o_data['shippingDetails']['shipping_street']." ".$o_data['shippingDetails']['shipping_district'];
	$objAccount->shipping_address_city = $o_data['shippingDetails']['shipping_city'];
	$objAccount->shipping_address_state = $o_data['shippingDetails']['shipping_state'];
	$objAccount->shipping_address_postalcode = $o_data['shippingDetails']['shipping_zip'];
	$objAccount->shipping_address_country = $o_data['shippingDetails']['shipping_country'];

	$objAccount->save();

	$account_arr = array();
	$account_arr['account_id'] = $objAccount->id;

	return $account_arr;
}

function newContact($a_data,$l_data,$o_data){
	$objContact = new Contact();
	$objContact->first_name = $l_data['fname'];
	$objContact->last_name = $l_data['lname'];
	$objContact->email1 = $o_data['cust_email'];
	$objContact->phone_work = $o_data['shippingDetails']['shipping_telephone'];
	$objContact->phone_mobile = $o_data['billingDetails']['billing_telephone'];

	$objContact->primary_address_street = $o_data['billingDetails']['billing_street']." ".$o_data['billingDetails']['billing_district'];
	$objContact->primary_address_city = $o_data['billingDetails']['billing_city'];
	$objContact->primary_address_state = $o_data['billingDetails']['billing_state'];
	$objContact->primary_address_postalcode = $o_data['billingDetails']['billing_zip'];
	$objContact->primary_address_country =  $o_data['billingDetails']['billing_country'];

	$objContact->alt_address_street = $o_data['shippingDetails']['shipping_street']." ".$o_data['shippingDetails']['shipping_district'];
	$objContact->alt_address_city = $o_data['shippingDetails']['shipping_city'];
	$objContact->alt_address_state = $o_data['shippingDetails']['shipping_state'];
	$objContact->alt_address_postalcode = $o_data['shippingDetails']['shipping_zip'];
	$objContact->alt_address_country = $o_data['shippingDetails']['shipping_country'];

	$objContact->account_id = $a_data['account_id'];

	$objContact->save();

	$contact_arr = array();
	$contact_arr['contact_id'] = $objContact->id;

	return $contact_arr;

}

function updateContact($c_id,$a_data,$l_data,$o_data){
	$objContact = new Contact();

	$objContact->retrieve($c_id);

	$objContact->first_name = $l_data['fname'];
	$objContact->last_name = $l_data['lname'];
	$objContact->email1 = $o_data['cust_email'];
	$objContact->phone_work = $o_data['shippingDetails']['shipping_telephone'];
	$objContact->phone_mobile = $o_data['billingDetails']['billing_telephone'];

	$objContact->primary_address_street = $o_data['billingDetails']['billing_street']." ".$o_data['billingDetails']['billing_district'];
	$objContact->primary_address_city = $o_data['billingDetails']['billing_city'];
	$objContact->primary_address_state = $o_data['billingDetails']['billing_state'];
	$objContact->primary_address_postalcode = $o_data['billingDetails']['billing_zip'];
	$objContact->primary_address_country =  $o_data['billingDetails']['billing_country'];

	$objContact->alt_address_street = $o_data['shippingDetails']['shipping_street']." ".$o_data['shippingDetails']['shipping_district'];
	$objContact->alt_address_city = $o_data['shippingDetails']['shipping_city'];
	$objContact->alt_address_state = $o_data['shippingDetails']['shipping_state'];
	$objContact->alt_address_postalcode = $o_data['shippingDetails']['shipping_zip'];
	$objContact->alt_address_country = $o_data['shippingDetails']['shipping_country'];

	$objContact->account_id = $a_data['account_id'];

	$objContact->save();

	$contact_arr = array();
	$contact_arr['contact_id'] = $objContact->id;

	return $contact_arr;

}

function newOpportunity($a_data,$c_data,$l_data,$o_data){
	if (file_exists("dmc_MGD_PRO.php")){
		require_once('dmc_MGD_PRO.php');
		$ret = newOpportunity_pro($a_data,$c_data,$l_data,$o_data); 
		return $ret;
	}
	return ;
}



function leadConversion($lead_id, $account_id, $contact_id, $opportunity_id, $order_data){
	global $db;
	if($account_id=='' and $contact_id=='' and $opportunity_id==''){

		$lead_data = updateLead($lead_id,$order_data);

		$account_data = newAccount($lead_data,$order_data);

		$contact_data = newContact($account_data,$lead_data,$order_data);

	if (file_exists("dmc_MGD_PRO.php")){
		$opportunity_data = newOpportunity($account_data,$contact_data,$lead_data,$order_data);
		$query = "UPDATE leads SET converted='1', status='Converted', contact_id='".$contact_data['contact_id']."', account_id='".$account_data['account_id']."', opportunity_id='".$opportunity_data['opportunity_id']."' WHERE  id='".$lead_data['lead_id']."' AND deleted=0";
	}else{
		$query = "UPDATE leads SET converted='1', status='Converted', contact_id='".$contact_data['contact_id']."', account_id='".$account_data['	account_id']."' WHERE  id='".$lead_data['lead_id']."' AND deleted=0";
	}

		$db->query($query,true,"Error converting lead. Magento. ");

	}else{
		$account_data = array('account_id' => $account_id);
		$contact_data = array('contact_id' => $contact_id);
		
		$lead_data = updateLead($lead_id,$order_data);

		if($account_id==''){
			$account_data = newAccount($lead_data,$order_data);
		}else{
			$account_data = updateAccount($account_id,$lead_data,$order_data);
		}

		if($contact_id==''){
			$contact_data = newContact($account_data,$lead_data,$order_data);
		}else{
			$contact_data = updateContact($contact_id,$account_data,$lead_data,$order_data);
		}
		
		if (file_exists("dmc_MGD_PRO.php")){
			$opportunity_data = newOpportunity($account_data,$contact_data,$lead_data,$order_data);
		}
	
	}	

}


	$order_data_m = $_POST['order_data'];
	$order_data_m = str_replace("&quot;","\"",$order_data_m);
	$order_data_m = json_decode($order_data_m,true);


	global $db;	
	
	if($order_data_m['cust_id']!=''){

		$strQuery = "SELECT * FROM leads JOIN leads_cstm ON id_c=id WHERE magento_id_c ='".$order_data_m['cust_id']."' AND deleted=0 ";
		$result = $db->query($strQuery);

		if ($arRow = $db->fetchByAssoc($result)){

			$lead_id = $arRow['id_c'];
			$account_id = $arRow['account_id'];
			$contact_id = $arRow['contact_id'];
			$opportunity_id = $arRow['opportunity_id'];

			$lead_conv = leadConversion($lead_id, $account_id, $contact_id, $opportunity_id, $order_data_m);
	
		}else{
			$lead_data = newLead($order_data_m);

			$lead_id = $lead_data['lead_id'];
			$account_id = "";
			$contact_id = "";
			$opportunity_id = "";

			$lead_conv = leadConversion($lead_id, $account_id, $contact_id, $opportunity_id, $order_data_m);

			}
	}else{
		$order_data_m['cust_id']="guest".date("Y-m-d G:i:s");
		$lead_data = newLead($order_data_m);

		$lead_id = $lead_data['lead_id'];
			$account_id = "";
			$contact_id = "";
			$opportunity_id = "";

			$lead_conv = leadConversion($lead_id, $account_id, $contact_id, $opportunity_id, $order_data_m);
	}

} //end action registerorder


?>