<?php
/*
 * Contain all shortcodes for WooCommerce page builder
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit(); // Exit if accessed directly
}
$text_align_options = array( 
	esc_html__( 'Left', 'js_composer' ) => 'left', 
	esc_html__( 'Right', 'js_composer' ) => 'right', 
	esc_html__( 'Center', 'js_composer' ) => 'center', 
	esc_html__( 'Justify', 'js_composer' ) => 'justify' );
$show_hide_values = array( 
	esc_html__( 'Show', 'dt_woocommerce_page_builder' ) => 'show', 
	esc_html__( 'Hide', 'dt_woocommerce_page_builder' ) => 'hide' );
$order_by_values = array( 
	'', 
	esc_html__( 'Date', 'js_composer' ) => 'date', 
	esc_html__( 'Order by post ID', 'js_composer' ) => 'ID', 
	esc_html__( 'Author', 'js_composer' ) => 'author', 
	esc_html__( 'Title', 'js_composer' ) => 'title', 
	esc_html__( 'Last modified date', 'js_composer' ) => 'modified', 
	esc_html__( 'Random order', 'js_composer' ) => 'rand', 
	esc_html__( 'Number of comments', 'js_composer' ) => 'comment_count', 
	esc_html__( 'Menu order', 'dt_woocommerce_page_builder' ) => 'menu_order' );

$order_way_values = array( 
	'', 
	esc_html__( 'Descending', 'js_composer' ) => 'DESC', 
	esc_html__( 'Ascending', 'js_composer' ) => 'ASC' );

// Cart page builder
vc_map( 
	array( 
		"name" => esc_html__( "Cart Table", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_cart_table", 
		"category" => esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		"params" => array( 
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 
					'Style particular content element differently - add a class name and refer to it in custom CSS.', 
					'js_composer' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );

vc_map( 
	array( 
		"name" => esc_html__( "Cart Totals", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_cart_totals", 
		"category" => esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		"params" => array( 
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 
					'Style particular content element differently - add a class name and refer to it in custom CSS.', 
					'js_composer' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );

vc_map( 
	array( 
		"name" => esc_html__( "Cross Sells", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_cross_sell", 
		"category" => esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		"params" => array( 
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( "Product Per Page", 'dt_woocommerce_page_builder' ), 
				"param_name" => "posts_per_page", 
				"value" => 4 ), 
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( "Columns", 'dt_woocommerce_page_builder' ), 
				"param_name" => "columns", 
				"value" => 4 ), 
			array( 
				"type" => "dropdown", 
				"heading" => esc_html__( "Orderby", 'dt_woocommerce_page_builder' ), 
				"param_name" => "orderby", 
				'class' => '', 
				"value" => array( 
					__( 'Random', 'dt_woocommerce_page_builder' ) => 'rand', 
					__( 'Publish Date', 'dt_woocommerce_page_builder' ) => 'date', 
					__( 'Modified Date', 'dt_woocommerce_page_builder' ) => 'modified', 
					__( 'Alphabetic', 'dt_woocommerce_page_builder' ) => 'title', 
					__( 'Popularity', 'dt_woocommerce_page_builder' ) => 'popularity', 
					__( 'Rate', 'dt_woocommerce_page_builder' ) => 'rating', 
					__( 'Price', 'dt_woocommerce_page_builder' ) => 'price' ) ), 
			array( 
				"type" => "dropdown", 
				"heading" => esc_html__( "Order", 'dt_woocommerce_page_builder' ), 
				"param_name" => "order", 
				'class' => '', 
				"value" => array( 
					__( 'desc', 'dt_woocommerce_page_builder' ) => 'desc', 
					__( 'asc', 'dt_woocommerce_page_builder' ) => 'asc' ) ), 
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 
					'Style particular content element differently - add a class name and refer to it in custom CSS.', 
					'js_composer' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );

vc_map( 
	array( 
		"name" => esc_html__( "Empty Cart Message", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_empty_cart_message", 
		"category" => esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		"params" => array( 
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 
					'Style particular content element differently - add a class name and refer to it in custom CSS.', 
					'js_composer' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );
vc_map( 
	array( 
		"name" => esc_html__( "Return To Shop button", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_return_to_shop", 
		"category" => esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		"params" => array( 
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 
					'Style particular content element differently - add a class name and refer to it in custom CSS.', 
					'js_composer' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );
