<?php
/*
 * Contain all shortcodes for WooCommerce page builder
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit(); // Exit if accessed directly
}
$text_align_options = array( 
	esc_html__( 'Left', 'js_composer' ) => 'left', 
	esc_html__( 'Right', 'js_composer' ) => 'right', 
	esc_html__( 'Center', 'js_composer' ) => 'center', 
	esc_html__( 'Justify', 'js_composer' ) => 'justify' );
$show_hide_values = array( 
	esc_html__( 'Show', 'dt_woocommerce_page_builder' ) => 'show', 
	esc_html__( 'Hide', 'dt_woocommerce_page_builder' ) => 'hide' );
$order_by_values = array( 
	'', 
	esc_html__( 'Date', 'js_composer' ) => 'date', 
	esc_html__( 'Order by post ID', 'js_composer' ) => 'ID', 
	esc_html__( 'Author', 'js_composer' ) => 'author', 
	esc_html__( 'Title', 'js_composer' ) => 'title', 
	esc_html__( 'Last modified date', 'js_composer' ) => 'modified', 
	esc_html__( 'Random order', 'js_composer' ) => 'rand', 
	esc_html__( 'Number of comments', 'js_composer' ) => 'comment_count', 
	esc_html__( 'Menu order', 'dt_woocommerce_page_builder' ) => 'menu_order' );

$order_way_values = array( 
	'', 
	esc_html__( 'Descending', 'js_composer' ) => 'DESC', 
	esc_html__( 'Ascending', 'js_composer' ) => 'ASC' );

// Thank you
vc_map( 
	array( 
		"name" =>esc_html__( "Thank You Order", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_order_received_thankyou", 
		"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		"params" => array( 
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );

vc_map( 
	array( 
		"name" =>esc_html__( "Order Details", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_order_received_order_details", 
		"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		"params" => array( 
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );

vc_map( 
	array( 
		"name" =>esc_html__( "Order Customer Details", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_order_received_order_customer_details", 
		"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		"params" => array( 
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );
